unit Unit1;

interface

uses
    Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    Db, DBTables, Grids, DBGrids, ExtCtrls, DBCtrls, StdCtrls, ExRxDBGrid,
    RXDBCtrl;

type
    TForm1 = class(TForm)
        DBNavigator1: TDBNavigator;
        Table1: TTable;
        DataSource1: TDataSource;
        Panel1: TPanel;
        ExRxDBGrid1: TExRxDBGrid;
        CheckBox1: TCheckBox;
        CheckBox2: TCheckBox;
        CheckBox3: TCheckBox;
        CheckBox4: TCheckBox;
        CheckBox5: TCheckBox;
        Button1: TButton;
        Button2: TButton;
        Button3: TButton;
        Button4: TButton;
        Button5: TButton;
        procedure CheckBox1Click(Sender: TObject);
        procedure CheckBox2Click(Sender: TObject);
        procedure CheckBox3Click(Sender: TObject);
        procedure CheckBox4Click(Sender: TObject);
        procedure CheckBox5Click(Sender: TObject);
        procedure ExRxDBGrid1CheckButton(Sender: TObject; ACol: Integer;
            Field: TField; var Enabled: Boolean);
        procedure ExRxDBGrid1GetBtnParams(Sender: TObject; Field: TField;
            AFont: TFont; var Background: TColor; var SortMarker: TSortMarker;
            IsDown: Boolean);
        procedure ExRxDBGrid1TitleBtnClick(Sender: TObject; ACol: Integer;
            Field: TField);
        procedure Button1Click(Sender: TObject);
        procedure Button2Click(Sender: TObject);
        procedure Button3Click(Sender: TObject);
        procedure ExRxDBGrid1ApplyCellAttribute(Sender: TObject; Field: TField;
            Canvas: TCanvas; State: TGridDrawState);
        procedure Button4Click(Sender: TObject);
        procedure FormCreate(Sender: TObject);
        procedure Button5Click(Sender: TObject);
    private
        { Private declarations }
        FSortFieldName: string;
        FSortDesc: Boolean;
    public
        { Public declarations }
    end;

var
    Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
    ExRxDBGrid1.Perform(wm_Paint, 0, 0);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
    ExRxDBGrid1.DisplayBoolean := not ExRxDBGrid1.DisplayBoolean;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
    ExRxDBGrid1.DisplayImages := not ExRxDBGrid1.DisplayImages;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
    ExRxDBGrid1.DisplayMemo := not ExRxDBGrid1.DisplayMemo;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
    ExRxDBGrid1.RowSizingAllowed := not ExRxDBGrid1.RowSizingAllowed;
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
    ExRxDBGrid1.DefaultDrawing := not ExRxDBGrid1.DefaultDrawing;

    ExRxDBGrid1.DisplayBoolean := not ExRxDBGrid1.DisplayBoolean;
    ExRxDBGrid1.DisplayImages := not ExRxDBGrid1.DisplayImages;
    ExRxDBGrid1.DisplayMemo := not ExRxDBGrid1.DisplayMemo;
    ExRxDBGrid1.DisplayBoolean := not ExRxDBGrid1.DisplayBoolean;
    ExRxDBGrid1.DisplayImages := not ExRxDBGrid1.DisplayImages;
    ExRxDBGrid1.DisplayMemo := not ExRxDBGrid1.DisplayMemo;
end;

procedure TForm1.ExRxDBGrid1CheckButton(Sender: TObject; ACol: Integer;
    Field: TField; var Enabled: Boolean);
begin
    Enabled := (TTable(ExRxDBGrid1.DataSource.DataSet).Active = True) and
        (ExRxDBGrid1.DataSource.DataSet is TTable) and
        (Field <> nil) and not (Field is TBlobField) and
        (TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Count > 0);
end;

procedure TForm1.ExRxDBGrid1GetBtnParams(Sender: TObject; Field: TField;
    AFont: TFont; var Background: TColor; var SortMarker: TSortMarker;
    IsDown: Boolean);
var
    I: Integer;
    IndexFld: string;
    FldNameTmp: string;
begin
    if TTable(ExRxDBGrid1.DataSource.DataSet).Active = True then
        begin
            TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Update;
            if (ExRxDBGrid1.DataSource.DataSet is TTable) and (Field <> nil) then
                if TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Count <> 0 then
                    begin
                        for I := 0 to TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Count - 1 do
                            begin
                                IndexFld := VarToStr(TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Items[I].Fields);
                                FldNameTmp := Field.FieldName;
                                if IndexFld = FldNameTmp then
                                    begin
                                        Background := ExRxDBGrid1.FixedColor;
                                        break;
                                    end;
                            end;
                    end;

            if Field.FieldName = FSortFieldName then
                begin
                    if FSortDesc then
                        SortMarker := smUp
                    else
                        SortMarker := smNone;
                end;
        end;
end;

procedure TForm1.ExRxDBGrid1TitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
var
    I: Integer;
begin
    if TTable(ExRxDBGrid1.DataSource.DataSet).Active = True then
        begin
            TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Update;
            if ExRxDBGrid1.DataSource.DataSet is TTable then
                try
                    try
                        TTable(ExRxDBGrid1.DataSource.DataSet).IndexFieldNames := Field.FieldName;
                        TTable(ExRxDBGrid1.DataSource.DataSet).First;
                        FSortFieldName := Field.FieldName;
                        FSortDesc := True;
                    except
                        if ExRxDBGrid1.DataSource.DataSet is TTable then
                            try
                                TTable(ExRxDBGrid1.DataSource.DataSet).IndexName := Field.FieldName;
                                TTable(ExRxDBGrid1.DataSource.DataSet).First;
                                FSortFieldName := Field.FieldName;
                                FSortDesc := True;
                            except
                                TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Update;
                                if TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Count > 0 then
                                    begin
                                        for i := 0 to (TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Count - 1) do
                                            begin
                                                if TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Items[i].Fields = Field.FieldName then
                                                    begin
                                                        if ixPrimary in TTable(ExRxDBGrid1.DataSource.DataSet).IndexDefs.Items[i].Options then
                                                            begin
                                                                try
                                                                    TTable(ExRxDBGrid1.DataSource.DataSet).IndexName := 'PrimaryKey';
                                                                    TTable(ExRxDBGrid1.DataSource.DataSet).First;
                                                                    FSortFieldName := Field.FieldName;
                                                                    FSortDesc := True;
                                                                except
                                                                    TTable(ExRxDBGrid1.DataSource.DataSet).IndexName := 'Primary';
                                                                    TTable(ExRxDBGrid1.DataSource.DataSet).First;
                                                                    FSortFieldName := Field.FieldName;
                                                                    FSortDesc := True;
                                                                end;
                                                                break;
                                                            end;
                                                    end;
                                            end;
                                    end
                            end;
                    end;
                except
                    TTable(ExRxDBGrid1.DataSource.DataSet).IndexFieldNames := '';
                    TTable(ExRxDBGrid1.DataSource.DataSet).First;
                    FSortFieldName := '';
                    FSortDesc := False;
                end;
        end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
    if Button1.Caption = 'Autosize Off' then
        begin
            Table1.DisableControls;
            ExRxDBGrid1.GridAutoSize := True;
            Table1.EnableControls;
            Button1.Caption := 'Autosize On'
        end
    else
        begin
            Table1.DisableControls;
            ExRxDBGrid1.GridAutoSize := False;
            Table1.EnableControls;
            Button1.Caption := 'Autosize Off'
        end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
    if Button2.Caption = 'FullSizeMemo Off' then
        begin
            Table1.DisableControls;
            ExRxDBGrid1.FullSizeMemo := True;
            Table1.EnableControls;
            Button2.Caption := 'FullSizeMemo On'
        end
    else
        begin
            Table1.DisableControls;
            ExRxDBGrid1.FullSizeMemo := False;
            Table1.EnableControls;
            Button2.Caption := 'FullSizeMemo Off'
        end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
    if Button3.Caption = 'FlatStyle On' then
        begin
            Table1.DisableControls;
            ExRxDBGrid1.Cells3D := True;
            Table1.EnableControls;
            Button3.Caption := 'Cells3D On'
        end
    else
        begin
            Table1.DisableControls;
            ExRxDBGrid1.Cells3D := False;
            Table1.EnableControls;
            Button3.Caption := 'FlatStyle On'
        end;
end;

procedure TForm1.ExRxDBGrid1ApplyCellAttribute(Sender: TObject;
    Field: TField; Canvas: TCanvas; State: TGridDrawState);
begin
    if Field = Table1.Fields[0] then
        if not (gdSelected in State) then
            Canvas.Font.Color := clBlue;

    if Field = Table1.Fields[1] then
        if not (gdSelected in State) then
            Canvas.Font.Color := clRed;

    if Field = Table1.Fields[2] then
        Canvas.Font.Style := Canvas.Font.Style + [fsBold];

    if Field = Table1.Fields[3] then
        if not (gdSelected in State) then
            Canvas.Brush.Color := clGreen;

    if Field = Table1.Fields[4] then
        if Table1.Fields[4].AsInteger > 30 then
            if not (gdSelected in State) then
                Canvas.Font.Color := clYellow;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
    if Button4.Caption = 'AutoWidth Off' then
        begin
            ExRxDBGrid1.Align := alNone;
            ExRxDBGrid1.Width := ExRxDBGrid1.OptWidth;
            Button4.Caption := 'AutoWidth On';
        end
    else
        begin
            ExRxDBGrid1.Align := alClient;
            Button4.Caption := 'AutoWidth Off';
        end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
    if Button5.Caption = 'CellHints Off' then
        begin
            Table1.DisableControls;
            ExRxDBGrid1.CellHints := True;
            Table1.EnableControls;
            Button5.Caption := 'CellHints On'
        end
    else
        begin
            Table1.DisableControls;
            ExRxDBGrid1.CellHints := False;
            Table1.EnableControls;
            Button5.Caption := 'CellHints Off'
        end;
end;

end.

